<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', 'HomeController@index')->name('home');
Route::get('/about', 'AboutController@about')->name('about');
Route::get('/resources', 'ResourcesController@resources')->name('resources');
Route::get('/recruiter', 'RecruiterController@recruiter')->name('recruiter');
Route::get('/blog', 'BlogController@blog')->name('blog');
Route::get('/blog/{slug}', 'BlogController@blogDetails')->name('blogDetails');
Route::get('/contact', 'ContactController@contact')->name('contact');
Route::post('/contact-form-submit', 'ContactController@ContactFormSubmit')->name('contact-form-submit');

Route::post('/subscribe-form-submit', 'ContactController@subscribe')->name('subscribeFormSubmit');
Route::post('/call-form-submit', 'RecruiterController@callSubmit')->name('callSubmit');