@extends('layouts.app')
@section('meta')
@endsection
@section('title')
@endsection
@section('css')
    <!-- Css_link -->
    <link rel="stylesheet" href="{{asset('js/magnific-popup.css')}}">
    <link rel="stylesheet" href="{{asset('css/style.css')}}">
    <link rel="stylesheet" href="{{asset('css/Responsive.css')}}">
    <link rel="stylesheet" href="{{asset('css/bootstrap.min.css')}}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css" integrity="sha512-tS3S5qG0BlhnQROyJXvNjeEM4UpMXHrQfTGmbQ1gKmelCxlSEBUaxhRBj/EFTzpbP4RVSrpEikbmdJobCvhE3g==" crossorigin="anonymous" referrerpolicy="no-referrer"
    />
    <!-- slick_style -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick-theme.css" integrity="sha512-6lLUdeQ5uheMFbWm3CP271l14RsX1xtx+J5x2yeIDkkiBpeVTNhTqijME7GgRKKi6hCqovwCoBTlRBEC20M8Mg==" crossorigin="anonymous" referrerpolicy="no-referrer"
    />

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.css" integrity="sha512-yHknP1/AwR+yx26cB1y0cjvQUMvEa2PFzt1c9LlS4pRQ5NOTZFWbhBig+X9G9eYW/8m0/4OXNx8pxJ6z57x0dw==" crossorigin="anonymous" referrerpolicy="no-referrer"
    />

    <!-- Google_font_link -->
    <link href="https://fonts.googleapis.com/css2?family=Fredericka+the+Great&family=Libre+Baskerville:wght@400;700&family=Playfair+Display:wght@400;700&family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">

    <!-- Font_awosome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw==" crossorigin="anonymous" referrerpolicy="no-referrer"
    />
    <!-- swiper_css -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Swiper/8.4.5/swiper-bundle.min.css" integrity="sha512-okkLcBJE+U19Dpd0QdHA1wn4YY6rW3CwaxeLJT3Jmj9ZcNSbln/VYw8UdqXRIwLX7J8PmtHs0I/FPAhozFvXKg==" crossorigin="anonymous" referrerpolicy="no-referrer"
    />
@endsection
@section('content')

    <div class="container">
        <section class="contact_us">    
            <div class="container">
                <div class="row">
                    <div class="col-md-10 offset-md-1">
                        <div class="contact_inner">
                            <div class="row">
                                <div class="col-md-10">
                                    <div class="contact_form_inner">

                                        <div class="contact_field">
                                            <h3>Contact Us</h3>
                                            <p>Contact us whenever for assistance. We'll respond promptly to your inquiries and provide the support you need.</p>
                                            <form id="contact-form">
                                                <input type="email" class="form-control form-group email" name="email" placeholder="Email" pattern="[a-z0-9._%+-]+@[a-z0-9.-]+\.[a-z]{2,4}$" required/>
                                                <p class="text-danger" id="errorEmail" style="text-align: center;"></p>
                                                <div class="row">
                                                    <div class="col-lg-6">
                                                        <input type="tel" class="form-control form-group phone" placeholder="Phone" name="phone" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');" required/>
                                                        <p class="text-danger" id="errorPh" style="text-align: center; font-size: 10px !important"></p>
                                                    </div>
                                                    <div class="col-lg-6">
                                                        <select class="form-select opt_menu subject" name="subject" aria-label="Default select example" required>
                                                            <option value="">Choose One</option>
                                                            <option value="Recruiters">Recruiters </option>
                                                            <option value="Job Seeker">Job Seeker</option>
                                                        </select>
                                                        <p class="text-danger" id="errorSub" style="text-align: center; font-size: 10px !important"></p>
                                                    </div>
                                                </div>
                                                <textarea class="form-control form-group message" name="message" placeholder="Message" required></textarea>
                                                <p class="text-danger" id="errorMsg" style="text-align: center; font-size: 8px;"></p>
                                                <button class="contact_form_submit" type="button" onclick="savecontact()">SUBMIT</button>
                                                <div id="msgSuccess" class="text-info text-center hidden contact_gap" "></div>
                                                <div class="clearfix"></div>
                                            </div> 
                                        </form>

                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="right_conatct_social_icon d-flex align-items-end">
                                        <div class="socil_item_inner d-flex">
                                            <li><a href="#"><i class="fa fa-facebook" aria-hidden="true"></i></a></li>
                                            <li><a href="#"><i class="fa fa-instagram" aria-hidden="true"></i></a></li>
                                            <li><a href="#"><i class="fa fa-twitter" aria-hidden="true"></i></a></li>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="contact_info_sec">
                                <h4>Contact Info</h4>
                                <h6>FOR RECRUITERS</h6>
                                <div class="info_single align-items-center">
                                    <i class="fas fa-headset"></i>
                                    <span>+91 8009 054294</span>
                                </div>
                                <div class="info_single align-items-center">
                                    <i class="fas fa-envelope-open-text"></i>
                                    <span>info@exampal.com</span>
                                </div>
                                <div class="ty">
                                    <h6>FOR Veterans</h6>
                                    <div class="info_single align-items-center">
                                        <i class="fas fa-headset"></i>
                                        <span>+91 8009 054294</span>
                                    </div>
                                    <div class="info_single align-items-center">
                                        <i class="fas fa-envelope-open-text"></i>
                                        <span>info@exampal.com</span>
                                    </div>
                                </div>
                                <div class="d-flex info_single align-items-center side_left">
                                    <span>Please provide your contact information below so that we can get in touch with you regarding your inquiry or request. Thank you!</span>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
   

    
    <section class="map_sec">
        <div class="container">
            <div class="row">
                <div class="col-md-10 offset-md-1">
                    <div class="map_inner">
                        <h4>Find Us on Google Map</h4>
                        <p>Locate us easily on Google Maps by searching for "Second Innings" and get directions to our location. We look ahead to welcoming you!</p>
                        <div class="map_bind">
                            <iframe src="https://www.google.com/maps/embed?pb=!1m10!1m8!1m3!1d7376.740484254972!2d87.3130944!3d22.4150864!3m2!1i1024!2i768!4f13.1!5e0!3m2!1sen!2sin!4v1679051515300!5m2!1sen!2sin" width="100%" height="450" style="border:0;" allowfullscreen="" loading="lazy"
                                referrerpolicy="no-referrer-when-downgrade"></iframe>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
   
@endsection
@section('js')

@endsection