@extends('layouts.app')
@section('meta')
<meta name="description" content="{{strip_tags($select_Blog_Details['summary'])}}">
<meta name="title" content="{{$select_Blog_Details['blogTitle']}} - Second Innings">
@endsection
@section('title')
<title>{{$select_Blog_Details['blogTitle']}} | Second Innings</title>
@endsection
@section('css')
    <link rel="stylesheet" href="{{asset('css/style.css')}}">
    <link rel="stylesheet" href="{{asset('css/Responsive.css')}}">
    <link rel="stylesheet" href="{{asset('css/bootstrap.min.css')}}">
    <link
        href="https://fonts.googleapis.com/css2?family=Fredericka+the+Great&family=Libre+Baskerville:wght@400;700&family=Playfair+Display:wght@400;700&family=Poppins:wght@400;500;600;700&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"
        integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="{{asset('css/utility.css')}}">
    <link rel="stylesheet" href="{{asset('css/module_header.css')}}">
    <link rel="stylesheet" href="{{asset('css/module_footer.css')}}">
    <link rel="stylesheet" href="{{asset('css/module_common.css')}}">

    <link href="{{asset('fonts/bignoodletitling_font.css')}}" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@400;500;600;700&display=swap" rel="stylesheet">

    <link href="https://cdn.jsdelivr.net/npm/remixicon@2.5.0/fonts/remixicon.css" rel="stylesheet">
    <link rel="stylesheet" href="{{asset('css/page_blogItem.css')}}">
    <link rel="stylesheet" href="{{asset('css/page_blog.css')}}">
@endsection

@section('content')
<main>
        <!-- ===== Start - Blog Container ===== -->
        <section class="blogWrapper">

            <!-- Start - Main Blog -->
            <article class="mainBlog">

                <!-- Feature Image -->
                <!-- <div class="blogImage">
                    <img src="{{asset('images/Blog/latest_blog_image.jpg')}}" alt="Latest Blog">
                </div> -->


                <!-- Blog Title -->
                <!-- <h2 class="title">Facebook Is Building A Compiler For React</h2> -->


                <!-- Blog Details -->
                <h4 class="details">@if (!empty($select_Blog_Details)) {!!$select_Blog_Details['blogDescription']!!} @endif
</h4>

                <!-- Blog Category -->
                <div class="category">
                    <div class="linkContainer">
                        <p class="text">Blog Tags : </p>
                        <a href="javascript:void(0)" class="link">Development</a>
                        <a href="javascript:void(0)" class="link">Facebook</a>
                    </div>
                </div>

            </article>
            <!-- End - Main Blog -->



            <!-- Start - Sidebar Links -->
            <article class="sidebar">

                
                

                <!-- Social Media Links -->
                <div class="social">
                    <p class="head">FOLLOW US</p>
                    <div class="linkContainer">
                        <a class="link" href="https://www.linkedin.com/company/bluehorse-software" target="_blank">
                            <img src="{{asset('images/Common/LinkedIn-Color.png')}}" alt="LinkedIn">
                            <p class="text">LinkedIn</p>
                        </a>
                        <a class="link" href="https://www.facebook.com/bluehorsesw" target="_blank">
                            <img src="{{asset('images/Common/Facebook-Color.png')}}" alt="Facebook">
                            <p class="text">Facebook</p>
                        </a>
                        <a class="link" href="https://www.instagram.com/bluehorse.in" target="_blank">
                            <img src="{{asset('images/Common/Instagram-Color.png')}}" alt="Instagram">
                            <p class="text">Instagram</p>
                        </a>
                        <a class="link" href="https://twitter.com/BlueHorse_sw" target="_blank">
                            <img src="{{asset('images/Common/Twitter-Color.png')}}" alt="Twitter">
                            <p class="text">Twitter</p>
                        </a>
                    </div>
                </div>

                <!-- Blog Categories -->
                

                <!-- Start - Other Blog Items -->
                <article class="latestBlogs">
                    <!-- Head -->
                    <p class="head">LATEST BLOGS</p>
                    @if(!empty($latestBlog))
                        @foreach($latestBlog as $blogValue)
                        <a href="{{route('blogDetails',['slug' => $blogValue['slug']])}}" class="blog">
                            <div class="image">
                                <img src="@if(!empty($blogValue['blogImage'])){{$blogValue['blogImage']}}@endif" alt="@if(!empty($blogValue['blogImage'])){{$blogValue['blogImage']}}@endif">
                            </div>
                            <div class="text">
                                <h3 class="title">@if(!empty($blogValue['blogTitle'])){{$blogValue['blogTitle']}}@endif</h3>
                                <p class="category">@if(!empty($blogValue['blogCategoryName'])){{$blogValue['blogCategoryName']}}@endif</p>
                            </div>
                        </a>
                        @endforeach
                    @endif

                    
                </article>
                <!-- End - Other Blog Items -->

            </article>
            <!-- End - Sidebar Links -->

        </section>
        <!-- ===== End - Blog Container ===== -->
    </main>
@endsection