@extends('layouts.app')
@section('meta')
@endsection
@section('title')
@endsection
@section('css')
    <!-- CSS Stylesheet -->
    <link rel="stylesheet" href="{{asset('css/style.css')}}">
    <link rel="stylesheet" href="{{asset('css/Responsive.css')}}">
    <link rel="stylesheet" href="{{asset('css/bootstrap.min.css')}}">
    <link
        href="https://fonts.googleapis.com/css2?family=Fredericka+the+Great&family=Libre+Baskerville:wght@400;700&family=Playfair+Display:wght@400;700&family=Poppins:wght@400;500;600;700&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"
        integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
        <link rel="stylesheet" href="{{asset('css/module_header.css')}}"> 
        <link rel="stylesheet" href="{{asset('css/module_footer.css')}}">
         <link rel="stylesheet" href="{{asset('css/module_common.css')}}"> 
        
        <link href="{{asset('fonts/bignoodletitling_font.css')}}" rel="stylesheet">
        <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@400;500;600;700&display=swap" rel="stylesheet">
        
        <link href="https://cdn.jsdelivr.net/npm/remixicon@2.5.0/fonts/remixicon.css" rel="stylesheet">
        
        <link rel="stylesheet" href="{{asset('css/page_blog.css')}}">
        <link rel="stylesheet" href="{{asset('css/utility.css')}}">
    
    
@endsection
@section('content')
<main>
<section class="blogIntroWrapper">
    @if(!empty($blogNewOne))
    <article class="latestBlog">
        <a href="{{route('blogDetails',['slug' => $blogNewOne['0']['slug']])}}">
            <img src="@if(!empty($blogNewOne['0']['blogImage'])){{$blogNewOne['0']['blogImage']}}@endif" alt="Latest Blog">
        </a>
        <a href="{{route('blogDetails',['slug' => $blogNewOne['0']['slug']])}}" class="title">@if(!empty($blogNewOne['0']['blogTitle'])){{$blogNewOne['0']['blogTitle']}}@endif</a>
        <div class="meta">
            <a href="{{route('blogDetails',['slug' => $blogNewOne['0']['slug']])}}" class="tag development">@if(!empty($blogNewOne['0']['blogCategoryName'])){{$blogNewOne['0']['blogCategoryName']}}@endif</a>
            <a href="{{route('blogDetails',['slug' => $blogNewOne['0']['slug']])}}" class="author">
                <img src="@if(!empty($blogNewOne['0']['authorProfilePic'])){{$blogNewOne['0']['authorProfilePic']}}@endif" alt="@if(!empty($blogNewOne['0']['authorProfilePic'])){{$blogNewOne['0']['authorProfilePic']}}@endif">
                <p class="name">@if(!empty($blogNewOne['0']['authorName'])){{$blogNewOne['0']['authorName']}}@endif</p>
            </a>
        </div>
        <a href="#" class="details details_box">@if(!empty($blogNewOne['0']['summary'])){!!substr($blogNewOne['0']['summary'],0,393)!!}@endif</a>
    </article>
    @endif
    <article class="sidebar">
        <div class="emailWrapper">
            <p class="head">NEWSLETTER</p>
            <form id="">
                <div class="form_inner">
                    <input class="email" type="email" placeholder="Email Address" id="newsletterEmail" required>
                    <input class="button" type="button" onclick="subscribeNewslatters()" value="JOIN">
                </div>
                <div id="errormail" class="text-info text-center hidden contact_gap"></div>
                <div class="clearfix"></div>
            </form>
        </div>
        <div class="social">
            <p class="head">FOLLOW US</p>
            <div class="linkContainer">
                <a href="javascript:void(0)" class="link">
                    <img src="{{asset('images/Common/LinkedIn-Color')}}.png" alt="LinkedIn">
                    <p class="text">LinkedIn</p>
                </a>
                <a href="javascript:void(0)" class="link">
                    <img src="{{asset('images/Common/Facebook-Color')}}.png" alt="Facebook">
                    <p class="text">Facebook</p>
                </a>
                <a href="javascript:void(0)" class="link">
                    <img src="{{asset('images/Common/Instagram-Color')}}.png" alt="Instagram">
                    <p class="text">Instagram</p>
                </a>
                <a href="javascript:void(0)" class="link">
                    <img src="{{asset('images/Common/Twitter-Color')}}.png" alt="Twitter">
                    <p class="text">Twitter</p>
                </a>
            </div>
        </div>
    </article>
</section>

<section class="blogArchive">
    

    <!-- Start - Blog Posts -->
    <article class="blogContainer">

        <!-- Blog Post -->
        @if(!empty($blog_details))
            @foreach($blog_details as $blogs)
                <article class="blog">
                    <a href="{{route('blogDetails',['slug' => $blogs['slug']])}}">
                    @if(!empty($blogs['blogImage']))
                        <img class="blog_img" src="{{$blogs['blogImage']}}" alt="Blog Archive 1" loading="lazy">
                    @else
                    <img class="blog_img" src="{{asset('images/blog_img.jpg')}}" alt="Blog Archive 1" loading="lazy">
                    @endif
                    </a>
                    <div class="meta">
                        <a href="javascript:void(0)" class="tag development">@if(!empty($blogs['blogCategoryName'])){{$blogs['blogCategoryName']}}@endif</a>
                        <p class="date">Date : {{startDate($blogs['createdAt'])}}</p>
                    </div>
                    <a href="{{route('blogDetails',['slug' => $blogs['slug']])}}" class="title">@if(!empty($blogs['blogTitle'])){{$blogs['blogTitle']}}@endif</a>
                    <a href="{{route('blogDetails',['slug' => $blogs['slug']])}}" class="details">@if(!empty($blogs['summary'])){!!$blogs['summary']!!}@endif</a>
                    
                    
                </article>
            @endforeach
        @endif

        

    </article>
    <!-- End - Blog Posts -->

    <!-- Blog Archive Pagination -->
    <div class="blog_holder">
        <article class="blogContainer" id="blog_div">
        </article>
    </div>

    <input type="hidden" value="{{count($blog_details)}}" id="blgcnt" />
    <div class="text-center">
        <button class="load_more" id="ldmore" type="button" onclick="loadmore();">View More Blogs</button>
    </div>

</section>
@php 
    function startDate($date)
    {
        $dateObj = new DateTime($date);
        $day = $dateObj->format('jS');
        $month = $dateObj->format('F Y');
        return $day . ' ' . $month;
    }
@endphp
</main>
@endsection