<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Http;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;


class RecruiterController extends Controller
{
    public function recruiter()
    {
        return view('recruters');
    }

    public function callSubmit(Request $request)
    {
         //dd($request->all());
            $validator = Validator::make($request->all(), [
            'subject' => 'required',
            'name' => 'required|string',
            'phone' => 'required|numeric|digits:10',
            'company' => 'string|max:100',
            'address' => 'required|string|max:100',
            'message' => 'required|string|max:500'
        ]);
        // dd($validator);

        if ($validator->fails()) {
            return response()->json([
                        'error' => $validator->errors()->all()
                    ]);
        }

        $ContactFormSubmitResponse = Http::post('https://wip.tezcommerce.com:3304/api/v1/contact/saveContact', [
            "data" => [
                "storeId" => 69,
                "firstName" => $request->name,
                "contactNo" => $request->phone,
                "address" => $request->address,
                "message" => $request->message,
                "brandName" => $request->company,
                "subject" => $request->subject,
            ]
        ]);
        $data = array();
        $contactFormSave = $ContactFormSubmitResponse->json(); 
        // dd($contactFormSave['data']['message']);
        if (isset($contactFormSave['errorNode']['errorCode']) && $contactFormSave['errorNode']['errorCode'] == 0) {
            $data = $contactFormSave['data']['message'];
        }
        
        return response()->json($data);

    }
}
